<?php
/*------------------------------------------------
 * Upload Photos in zip
 * Copyright © FinBoss 2024 
 *
 *
 * License: Commercial open source software (COSS) 
 *------------------------------------------------
 */

header('Content-Type: text/html; charset=utf-8');

date_default_timezone_set('Europe/Kiev');

// контроль доступа по IP
$a_allow = false;
if (is_file('../'.'.allowed_ip')){
	$a_ips = file('../'.'.allowed_ip');
	
	foreach ($a_ips as $a_ip){
		$a_ip = trim($a_ip);
		if (strpos($a_ip, '*') !== false){
			
			// process 127.0.*.*
			
			$remote = explode('.', $_SERVER['REMOTE_ADDR']);
			$a = explode('.', $a_ip);
			
			$true_count = 0;
			for ($i=0;$i<4;$i++){
				switch ($i){
					case 0:
					case 1:
						if ($remote[$i] != $a[$i]){
							break 2;
						}else{
							$true_count++;
						}
						break;
					case 2:
					case 3:
						if ($a[$i] == '*'){
							// пропускаем
							$true_count++;
						}else{
							if ($remote[$i] != $a[$i]){
								break 2;
							}else{
								$true_count++;
							}
						}
						
				}
			}
			if ($true_count == 4){
				$a_allow = true;
				break;
			}
			
		}else{
			if ($_SERVER['REMOTE_ADDR'] == trim($a_ip)){
				$a_allow = true;
				break;
			}
		}
	}
	
}
if ($a_allow === false){
	die('доступ для IP '.$_SERVER['REMOTE_ADDR'].' заблоковано');
}


/** Error reporting */
error_reporting(E_ALL);


$header ='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" >
<title>Завантажити файли з фото в архиві</title>
</head>
<body style="font-family:Trebuchet MS; font-size: 10pt">
';

$footer = '
</body></html>
';

echo $header;

	$extensions = array('jpg', 'png', 'jpeg', 'gif');
	$msg = '';
	$msg_start = '';

	if (isset($_POST['Load'])){
		
		// загрузка файла
		if ($_FILES['file']['error'] == 0){
			
			if (is_uploaded_file($_FILES['file']['tmp_name'])) {
				
				$path_parts = pathinfo($_FILES['file']['name']);
				if ($path_parts['extension'] == 'zip'){
					$zip = new ZipArchive;
					if ($zip->open($_FILES['file']['tmp_name']) === TRUE) {
					    $zip->extractTo('tmp/');
					    $zip->close();
					    //echo 'zip-архив загружен и распакован';
					    
					    $found = false;
					    $count = 0;
						$d = dir('tmp');
						while (false !== ($entry = $d->read())) {
							if ($entry != ".")
								if ($entry != ".."){
									$path_parts = pathinfo('tmp/'.$entry);
									if (in_array(strtolower($path_parts['extension']), $extensions)){
										$found = true;
										@unlink('files/'.$entry);
										rename('tmp/'.$entry, 'files/'.$entry);
										$count++;
									}else{
										@unlink('tmp/'.$entry);
									}
								}
						}
						$d->close();
						
						if (!$found){
							$msg = "Помилка: У zip-архіві відсутні файли з розширеннями '".implode("','", $extensions)."'";
						}else{
							$msg_start = "<br />Файл завантажений та розпакований. Усього завантажено $count фото";
						}
					    
					} else {
					    $msg = "Помилка: Не вдалося розпакувати zip-архів";
					}
					
				}else{
					$msg = "Помилка: Розширення завантаженого файлу не 'zip'";
				}
				
			}else{
				$msg = "Помилка: Не виявлено завантажений файл";
			}
		
		}else{
			switch($_FILES['file']['error']) {
			case '1':
				$msg = "Помилка: Розмір файлу, що завантажується, перевищує максимальний допустимий";break;
			case '2':
				$msg = "Помилка: Розмір файлу, що завантажується, перевищує максимальний допустимий";break;
			case '3':
				$msg = "Помилка: Завантажений файл було отримано лише частково";break;
			case '4':
				$msg = "Помилка: Файл не завантажено";break;
			case '6':
				$msg = "Помилка: На сервері немає папки для тимчасового зберігання файлів";break;
			case '7':
				$msg = "Помилка: Помилка запису файлу на диск";break;
			case '8':
				$msg = "Помилка: Завантаження файлу припинено - неприпустиме розширення файлу";break;
			default:
				$msg = "Помилка: При завантаженні файлу виникла невідома помилка";break;
				}
		}

	}
	
?>
<table width="100%" bgcolor="#416e98">
<tr valign="middle">
<td><a href="upload_photo.php"><span style="font-size:25px; color:#FFF; font-family:Trebuchet MS; decoration:none;">Завантажити файли з фото в архиві</span></a></td>
<td align="right"><span style="font-size:15px; color:#FFF; font-family:Trebuchet MS"></span></td>
</tr>
</table>
<br /><br />
<center>

<form method="post" enctype="multipart/form-data" name="excelform">
<table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" width="600">

<tr>
	<td width="200" align="right">
		<label for="file">
			Файл (zip): 
		</label>
	</td>
	<td width="400">
		<input type="file" id="file" name="file" size="45" />
	</td>
</tr>

<tr>
<td colspan="2" align="center"> <input type=submit value=Завантажити name=Load /> </td>
</tr>
<?php 
	if ($msg_start != ''){
?>
<tr>
<td colspan="2" align="center"> 
<br />
<?php echo $msg_start ?>
</tr>
<?php 
	}
?>
</table></form>

<a href="view_photo.php">Перегляд фото</a>

</center>
<?php 
if ($msg != ""){
	echo '<br />'.$msg;
	die;
}
		
echo $footer;


